<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;
    protected $fillable = array('address', 'phone');
    protected $visible = array('address', 'phone');

    public function accounts()
    {
        return $this->hasMany('Account', 'id_account');
    }

    public function licenses()
    {
        return $this->hasMany('License', 'id_license_kind');
    }

}